# ListPrepend()

Inserts an element at the beginning of a list.

```
ListPrepend( list=string, value=string, delimiters=string, includeEmptyFields=boolean );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| list | string | Yes | a string list |  |
| value | string | Yes | An element or a list of elements. |  |
| delimiters | string | No | Characters that separate list elements. The default value is comma. *Alias: delimiter* | , |
| includeEmptyFields | boolean | No | if false it cleans up empty fields. | true |

# Examples

```cfml
//Simple Example
writeoutput(listPrepend("Susi,LAS,,lucee,,,test","Inserted"));

//Member Function
strList=",I,,love,lucee,,";
writeDump(strList.listPrepend("First"));
```







# Categories

[Lists](../../categories/list.md), [Strings](../../categories/string.md)

# See Also

[string.listPrepend()](../objects/string/listprepend.md)