# ListMap()

Calls the given closure with every element in the given list.

The function returns a list that contains all values returned by the closure.

```
ListMap( list=string, closure=function, delimiter=string, includeEmptyFields=boolean, multiCharacterDelimiter=boolean, parallel=boolean, maxThreads=number );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| list | string | Yes | list to iterate |  |
| closure | function | Yes | filter can be a function/closure that implements the following constructor [function(any value, number index, string list, string delimiter):any]. *Alias: function, callback, udf* |  |
| delimiter | string | No | delimiter used to separate the string list | , |
| includeEmptyFields | boolean | No | include empty fields or not | false |
| multiCharacterDelimiter | boolean | No | specifying whether the delimiters parameter specifies a multi-character delimiter. If this parameter is true, the delimiters parameter must specify a single delimiter consisting of multiple characters. This parameter enables the ListToArray function to convert a list such as the following to an array of color names: red:\|orange:\|yellow:\|green:\|blue:\|indigo:\|violet. | true |
| parallel | boolean | No | execute closures parallel | false |
| maxThreads | number | No | maximum number of threads executed, ignored when argument "parallel" is set to false *Alias: maxThreadCount* | 20 |

# Examples

```cfml
	fruits = "apple,pear,orange";
	writedump(fruits);
	fruitsPlural = listMap( fruits, function(value, index, list) {
	    return value & "s";
	});
	writedump(fruitsPlural);
```







# Categories

[Collections](../../categories/collection.md), [Lists](../../categories/list.md), [Strings](../../categories/string.md), [Threads](../../categories/thread.md)

# See Also

[string.listMap()](../objects/string/listmap.md)