# ListLen()

Determines the number of elements in a list.

```
ListLen( list=string, delimiters=string, includeEmptyFields=boolean );
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| list | string | Yes | a string list |  |
| delimiters | string | No | Characters that separate list elements. The default value is comma. *Alias: delimiter* | , |
| includeEmptyFields | boolean | No | if set to true, empty values are included as well |  |

# Examples

```cfml
	writeDump(listLen("susi,sam,LAS,test"));//4
	writeDump(listLen("susi,,LAS,,"));//with empty values
	writeDump(listLen("susi,,LAS,,."));//3
```







# Categories

[Lists](../../categories/list.md), [Strings](../../categories/string.md)

# See Also

[string.ListLen()](../objects/string/listlen.md)