# ListLast()

Gets the last element of a list.

```
ListLast( list=string, delimiters=string, includeEmptyFields=boolean, count=number );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| list | string | Yes | a string list |  |
| delimiters | string | No | Characters that separate list elements. The default value is comma. *Alias: delimiter* | , |
| includeEmptyFields | boolean | No | if set to true, empty values are included as well | false |
| count | number | No | specifies how many items to return from the end of the list. default is 1. | 1 |

# Examples

```cfml
//Simple Example
writeoutput(listLast("Susi ,LAS,,lucee,,,test"));

//Member Function
strList=",I,,love,lucee,,";
writeDump(strList.listLast());
```







# Categories

[Lists](../../categories/list.md), [Strings](../../categories/string.md)

# See Also

[string.listLast()](../objects/string/listlast.md)