# ListItemTrim()

Removes all the white space surrounding each element, returning back the new list

```
ListItemTrim( list=string, delimiters=string, includeEmptyFields=boolean );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| list | string | Yes | a string list |  |
| delimiters | string | No | Characters that separate list elements. The default value is comma. *Alias: delimiter* | , |
| includeEmptyFields | boolean | No | if set to true, empty values are included as well |  |

# Examples

```cfml
//Simple Example
writeoutput(listItemTrim("Susi , LAS  ,,lucee,,,test,,"));

//Member Function
strList=",I,      , love,lucee  ,,";
writeDump(strList.listItemTrim());

```







# Categories

[Lists](../../categories/list.md), [Strings](../../categories/string.md)

# See Also

[ListChangeDelims()](listchangedelims.md), [string.listItemTrim()](../objects/string/listitemtrim.md)