# ListInsertAt()

Inserts an element in a list.

```
ListInsertAt( list=string, position=number, value=string, delimiters=string, includeEmptyFields=boolean );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| list | string | Yes | a string list |  |
| position | number | Yes | Position at which to insert element. The first list position is 1. |  |
| value | string | Yes | An element or a list of elements. |  |
| delimiters | string | No | Characters that separate list elements. The default value is comma. *Alias: delimiter* | , |
| includeEmptyFields | boolean | No | if set to true, empty values are included as well |  |

# Examples

```cfml
writeOutput(listInsertAt("a,,b,c,",1,"one"));

//Member Function with @ delimiter
strList="a@b@d";
writeDump(strList.listInsertAt(3,"c","@"));
```







# Categories

[Lists](../../categories/list.md), [Strings](../../categories/string.md)

# See Also

[string.listInsertAt()](../objects/string/listinsertat.md)