# ListIndexExists()

Determines if an element at the given position exists or not

```
ListIndexExists( list=string, index=number, delimiter=string, includeEmptyFields=boolean );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| list | string | Yes | a string list |  |
| index | number | Yes | index to check for. |  |
| delimiter | string | No | Characters that separate list elements. The default value is comma. | , |
| includeEmptyFields | boolean | No | if set to true, empty values are included as well | false |

# Examples

```cfml

//Simple Example
writeoutput(listIndexExists("Susi,LAS,,lucee,,,test",3));

//Member Function
strList=",I,,love,lucee,,";
writeDump(strList.listIndexExists(6));//Not exists, returns false

```







# Categories

[Lists](../../categories/list.md), [Strings](../../categories/string.md)

# See Also

[string.listIndexExists()](../objects/string/listindexexists.md)