# ListGetAt()

Gets a list element at a specified position.

```
ListGetAt( list=string, position=number, delimiters=string, includeEmptyFields=boolean );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| list | string | Yes | a string list |  |
| position | number | Yes | position of the element to return |  |
| delimiters | string | No | Characters that separate list elements. The default value is comma. *Alias: delimiter* | , |
| includeEmptyFields | boolean | No | if set to true, empty values are included as well | false |

# Examples

```cfml
writeOutput(listGetAt("a,,b,c,",3,",",true));//Returns b

//Member Function with '/' delimiter
strList="/a//b/c//d";
writeDump(strList.listGetAt(5,"/",true));//Expected output c
```







# Categories

[Lists](../../categories/list.md), [Strings](../../categories/string.md)

# See Also

[string.listGetAt()](../objects/string/listgetat.md)