# ListFirst()

Gets the first element of a list.

```
ListFirst( list=string, delimiters=string, includeEmptyFields=boolean, count=number );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| list | string | Yes | a string list |  |
| delimiters | string | No | Characters that separate list elements. The default value is comma. *Alias: delimiter* | , |
| includeEmptyFields | boolean | No | if set to true, empty values are included as well | false |
| count | number | No | specifies how many items to return from the beginning of the list. default is 1. | 1 |

# Examples

```cfml
writeOutput(listFirst("lucee,dev,LAS"));//Expected output lucee

//Member Function with @ delimiter
strList="dev@LAS@lucee";
writeDump(strList.listFirst("@"));//Expected output dev
```







# Categories

[Lists](../../categories/list.md), [Strings](../../categories/string.md)

# See Also

[string.listFirst()](../objects/string/listfirst.md)