# ListFindNoCase()

Determines the index of the first list element in which a
specified value occurs

```
ListFindNoCase( list=string, value=string, delimiters=string, includeEmptyFields=boolean );
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| list | string | Yes | a string list |  |
| value | string | Yes | element for which to search |  |
| delimiters | string | No | Characters that separate list elements. The default value is comma. *Alias: delimiter* | , |
| includeEmptyFields | boolean | No | if set to true, empty values are included as well | false |

# Examples

```cfml
writeOutput(listFindNoCase("I,love,lucee,testFile", "LUCEE"));//Expected output 3

//Member Function with @ delimiter
strList="I@am@lucee@dev";
writeDump(strList.listFindNoCase("Dev","@"));//Expected output 4
```







# Categories

[Lists](../../categories/list.md), [Strings](../../categories/string.md)

# See Also

[string.listFindNoCase()](../objects/string/listfindnocase.md)