# ListFilter()

This function creates a new string list that returns all entries from an string list that match the given filter.

```
ListFilter( list=string, filter=function, delimiter=string, includeEmptyFields=boolean, multiCharacterDelimiter=boolean, parallel=boolean, maxThreads=number );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| list | string | Yes | list to filter entries from |  |
| filter | function | Yes | A function/closure that implements the following constructor `function(any value, numeric index, string list, string delimiter) { return true/false;}` *Alias: closure, function, callback* |  |
| delimiter | string | No | delimiter used to separate the string list | , |
| includeEmptyFields | boolean | No | include empty fields or not | false |
| multiCharacterDelimiter | boolean | No | specifying whether the delimiters parameter specifies a multi-character delimiter. If this parameter is true, the delimiters parameter must specify a single delimiter consisting of multiple characters. This parameter enables the ListToArray function to convert a list such as the following to an array of color names: red:\|orange:\|yellow:\|green:\|blue:\|indigo:\|violet. | true |
| parallel | boolean | No | execute closures parallel | false |
| maxThreads | number | No | maximum number of threads executed, ignored when argument "parallel" is set to false *Alias: maxThreadCount* | 20 |

# Examples

```cfml
mylist = "Save|Water|Plant|green";
filterResult = listFilter(mylist,
	function(element, idx){
		if(element != "water" ){
			return true;
		}
		return false;
	}, "|"
);
writeDump(filterResult);


//Member Function
listVal="one,two,three,four,five";
res=listVal.listFilter(
	function(elem,ind){
		if(elem!="three"){
			return true;
		}
		return false;
	});
writeDump(res);
```







# Categories

[Lists](../../categories/list.md), [Strings](../../categories/string.md), [Collections](../../categories/collection.md)

# See Also

[string.listFilter()](../objects/string/listfilter.md)