# ListEach()

call the given UDF/Closure with every value in the string list.

```
ListEach( list=string, closure=function, delimiter=string, includeEmptyFields=boolean, multiCharacterDelimiter=boolean, parallel=boolean, maxThreads=number );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| list | string | Yes | string list to iterate |  |
| closure | function | Yes | function/closure that implements the following constructor `function(element, index, list){}` *Alias: function, callback, udf* |  |
| delimiter | string | No | delimiter used to separate the string list | , |
| includeEmptyFields | boolean | No | include empty fields or not | false |
| multiCharacterDelimiter | boolean | No | specify whether the delimiters parameter is a multi-character delimiter. If this parameter is true, the delimiters parameter must specify a single delimiter consisting of multiple characters. This parameter enables the [ListToArray()](listtoarray.md) function to convert a list such as the following to an array of color names: red:\|orange:\|yellow:\|green:\|blue:\|indigo:\|violet. | true |
| parallel | boolean | No | execute closures parallel | false |
| maxThreads | number | No | maximum number of threads executed, ignored when argument "parallel" is set to false *Alias: maxThreadCount* | 20 |

# Examples

```cfml

    list = "Plant,green,save,earth";
    listEach(list, function(element,index,list) {
        writeOutput("#index#:#element#;<br>");
    });

    //Member function with custom delimiter
    writeOutput("<br>Member Function<br>");
    strLst="one+two+three";
    strLst.listEach(function(element,index,list) {
        writeOutput("#index#:#element#;<br>");
    },"+");
```







# Categories

[Collections](../../categories/collection.md), [Lists](../../categories/list.md), [Strings](../../categories/string.md), [Threads](../../categories/thread.md)

# See Also

[string.listEach()](../objects/string/listeach.md)