# ListDeleteAt()

Deletes an element from a list.
Returns a copy of the list, without the specified element.

```
ListDeleteAt( list=string, position=number, delimiters=string, includeEmptyFields=boolean );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| list | string | Yes | a string list |  |
| position | number | Yes | position of the element to delete |  |
| delimiters | string | No | Characters that separate list elements. The default value is comma. *Alias: delimiter* | , |
| includeEmptyFields | boolean | No | if set to true, empty values are included as well | false |

# Examples

```cfml
writeOutput(listDeleteAt("I,love,lucee,testFile", 4));//Expected output I,love,lucee

//Member Function
strList="This,is,a,the,test,file";
writeDump(strList.listDeleteAt(3));//Expected output This,is,the,test,file
```







# Categories

[Lists](../../categories/list.md), [Strings](../../categories/string.md)

# See Also

[string.listDeleteAt()](../objects/string/listdeleteat.md)