# ListContains()

Determines the index of the first list element that contains a
specified substring.
Returns the index of the first list element that contains
substring. If not found, returns zero.

```
ListContains( list=string, substring=string, delimiters=string, includeEmptyFields=boolean, multiCharacterDelimiter=boolean );
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| list | string | Yes | a string list |  |
| substring | string | Yes | the string to search in the list |  |
| delimiters | string | No | Characters that separate list elements. The default value is comma. *Alias: delimiter* | , |
| includeEmptyFields | boolean | No | if set to true, empty values are included as well | false |
| multiCharacterDelimiter | boolean | No | specifying whether the delimiters parameter specifies a multi-character delimiter. If this parameter is true, the delimiters parameter must specify a single delimiter consisting of multiple characters. This parameter enables the ListToArray function to convert a list such as the following to an array of color names: red:\|orange:\|yellow:\|green:\|blue:\|indigo:\|violet. | false |

# Examples

```cfml
writeOutput(listContains("I,love,lucee,testFile", "lucee"));//Expected output 3

//Member Function with @ delimiter
strList="I@am@lucee@dev";
writeDump(strList.listContains("dev","@"));//Expected output 4
```







# Categories

[Lists](../../categories/list.md), [Strings](../../categories/string.md)

# See Also

[string.listContains()](../objects/string/listcontains.md)