# ListCompact()

Removes any empty items from the start and end of the list

```
ListCompact( list=string, delimiters=string, multiCharacterDelimiter=boolean );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| list | string | Yes | a string list |  |
| delimiters | string | No | Characters that separate list elements. The default value is comma. *Alias: delimiter* | , |
| multiCharacterDelimiter | boolean | No | specifying whether the delimiters parameter specifies a multi-character delimiter. If this parameter is true, the delimiters parameter must specify a single delimiter consisting of multiple characters. This parameter enables the ListToArray function to convert a list such as the following to an array of color names: red:\|orange:\|yellow:\|green:\|blue:\|indigo:\|violet. | false |

# Examples

```cfml
//Simple function
writeOutput(listCompact(',,,Plant,green,save,earth,,'));

//Member function with custom delimiter
strLst="+++1+2+3+4+++++++";
writeDump(strLst.listCompact("+"));
```







# Categories

[Lists](../../categories/list.md), [Strings](../../categories/string.md)

# See Also

[string.listCompact()](../objects/string/listcompact.md)