# ListChangeDelims()

Changes a list delimiter.
Returns a copy of the list, with each delimiter character
replaced by new_delimiter.

```
ListChangeDelims( list=string, new_delimiter=string, delimiters=string, includeEmptyFields=boolean, multiCharacterDelimiter=boolean );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| list | string | Yes | a string list |  |
| new_delimiter | string | Yes | new delimiter to set. a delimiter is a characters that separate list elements. |  |
| delimiters | string | No | existing delimiter to replace. a delimiter is a characters that separate list elements. The default value is comma. *Alias: delimiter* | , |
| includeEmptyFields | boolean | No | if set to true, empty values are included as well | false |
| multiCharacterDelimiter | boolean | No | specifying whether the delimiters parameter specifies a multi-character delimiter. If this parameter is true, the delimiters parameter must specify a single delimiter consisting of multiple characters. This parameter enables the [ListToArray()](listtoarray.md) function to convert a list such as the following to an array of color names: red:\|orange:\|yellow:\|green:\|blue:\|indigo:\|violet. | false |

# Examples

```cfml
//Simple function
writeOutput(ListChangeDelims('Plant,green,save,earth',"@"));

//Member function with custom delimiter
strLst="1+2+3+4";
writeDump(strLst.listChangeDelims("/", "+"));
```







# Categories

[Lists](../../categories/list.md), [Strings](../../categories/string.md)

# See Also

[ListItemTrim()](listitemtrim.md), [string.listChangeDelims()](../objects/string/listchangedelims.md)