# ListAppend()

Concatenates a list or element to a list.

```
ListAppend( list=string, value=string, delimiters=string, includeEmptyFields=boolean );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| list | string | Yes | a string list |  |
| value | string | Yes | a string value |  |
| delimiters | string | No | Characters that separate list elements. The default value is comma. If this string contains more than one character, only the first character is used. *Alias: delimiter* | , |
| includeEmptyFields | boolean | No | if false it cleans up empty fields. | true |

# Examples

Example without delimiter argument:

```cfml
mylist = "one,two,three";
mynewlist = listAppend(mylist, "four");
// Note that listAppend creates a new list. It doesn't update the existing list:
writeDump(mylist);
writeDump(mynewlist);
```

Expected result: `one,two,three,four`

Example with delimiter argument:

```cfml
mylist = "foo";
mynewlist = listAppend(mylist, "bar", "|");
writeDump(mynewlist);
```

Expected result: `foo|bar`







# Categories

[Lists](../../categories/list.md), [Strings](../../categories/string.md)

# See Also

[string.listAppend()](../objects/string/listappend.md)