# Len()

Determines the length of a string, array or struct

```
Len( value=object );
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| value | object | Yes | the object to measure the length of *Alias: string, object* |  |

# Examples

### Simple example for Len

```cfml
str="I love lucee";
dump(var=len(str), label="String");
dump(str);

arr =[1,2,3];
dump(var=len(arr), label="Array");
dump(arr);

st ={ a: 1};
dump(var=len(st), label="Struct");
dump(st);

q =query(a:["1,2,3"]);
dump(var=len(q), label="Query");
dump(q);
```

### Member Function

```cfml
str=['I','love','lucee'];
writeOutput(str.len());//3
```







# Categories

[Arrays](../../categories/array.md), [Core CFML Language](../../categories/core.md), [Strings](../../categories/string.md), [Structures](../../categories/struct.md), [Decision logic](../../categories/decision.md)

# See Also

[ArrayLen()](arraylen.md), [QueryRecordCount()](queryrecordcount.md), [StringLen()](stringlen.md), [StructCount()](structcount.md)