# JavaCast()

Converts the data type of a CFML variable to pass as an argument to an overloaded method of a Java object.

Use only for scalar and string arguments.

```
JavaCast( type=string, variable=any, javaSettings=struct );
```

**Returns:** any

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| type | string | Yes | Data type to which to convert variable: bigdecimal (converts to java.math.BigDecimal) - boolean - byte - char - int - long - float - double - short - string - {type}[] - where {type} is any of the preceding types, e.g. string[] - null - see also the built in function nullValue() - a Java class name |  |
| variable | any | Yes | the object to cast |  |
| javaSettings | struct | No | javasettings to use to load the class |  |

# Examples

```cfml
// Convert a ColdFusion Number to a Java double primitive
// Converts the number 180.0 degrees to radians using Java method: Math.toRadians(double degrees)
writeDump( createObject("java", "java.lang.Math").toRadians( javacast("double", 180.0) ) );
```







# Categories

[Java](../../categories/java.md)

# See Also

[Java - Explicit Casting of a Component to a Specific Interface](../../recipes/java-explicit-casting.md)