# IsXmlAttribute()

Determines whether the function parameter is an
XML Document Object Model (DOM) attribute node.

```
IsXmlAttribute( value=any );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| value | any | Yes | Name of an XML attribute |  |

# Examples

```cfml
	myPath='<note><from body="sample">Bob</from></note>';
	lastnames = XmlSearch(myPath, '//@body');
	writeDump(lastnames);
	writeOutput(isXMLAttribute(lastnames[1]));
```







# Categories

[Decision logic](../../categories/decision.md), [XML](../../categories/xml.md)