# IsXML()

Determines whether a string is well-formed XML text.

```
IsXML( value=any, xmlFeatures=struct );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| value | any | Yes | A string containing the XML document text |  |
| xmlFeatures | struct | No | A struct of xmlFeatures directives to override defaults |  |

# Examples

```cfml
globalVar = '<Earth>
 <required>
  <name>Trees</name>
 </required>
 <required>
  <name>Water</name>
 </required>
 <required>
  <name>Agriculture</name>
 </required>
 <required>
  <name>Humanity</name>
 </required>
</Earth>';
writeOutput(isXml(globalVar));
```







# Categories

[Decision logic](../../categories/decision.md), [XML](../../categories/xml.md)