# IsUserInRole()

Determines whether an authenticated user belongs to the
specified Role.

```
IsUserInRole( role_name=any );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| role_name | any | Yes | Name of a security role *Alias: roleName, role, name, value* |  |

# Examples

```cfml
<cflogin>
    <cfloginuser name = "test" password = "password" roles = "user,admin,editor">
</cflogin>

<cfdump var="#IsUserInRole(role_name="admin")#" />
```







# Categories

[Decision logic](../../categories/decision.md)

# See Also

[GetUserRoles()](getuserroles.md), [<cflogin>](../tags/login.md), [<cfloginuser>](../tags/loginuser.md)