# IsSimpleValue()

Determines if the object represents a simple value like a `string`, `number`, `boolean` etc

A `null` value is not a simple value

```
IsSimpleValue( value=any );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| value | any | Yes | Variable or expression |  |

# Examples

```cfml
	writeOutput( "string " & isSimpleValue("string") & "<br>" );
	writeOutput( "123456 " & isSimpleValue(123456) & "<br>" );
	writeOutput( "getTimezone() " & isSimpleValue(getTimezone()) & "<br>" );
	writeOutput( "now() " & isSimpleValue(now()) & "<br>" );
	writeOutput( 'javacast("char","A") ' & isSimpleValue(javacast("char","A")) & "<br>" );
	writeOutput( "nullValue() " & isSimpleValue(nullValue()) & "<br>" );
	writeOutput( "[] " & isSimpleValue([]) & "<br>" );
	writeOutput( "{} " & isSimpleValue({}) & "<br>" );
	writeOutput( 'queryNew("test") ' & isSimpleValue(queryNew("test")) & "<br>");
	writeOutput( " " & isSimpleValue("") );
```







# Categories

[Decision logic](../../categories/decision.md)