# IsPDFObject()

Determines whether a value is a PDF object.

**Requires Extension:** [PDF Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#66E312DD-D083-27C0-64189D16753FD6F0)

```
IsPDFObject( value=any );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| value | any | Yes | A value, typically the PDF object stored as a variable name. |  |

# Examples

```cfml
<cfdocument name="test" format="pdf">
    <h1>Welcome to Lucee</h1>
</cfdocument>
<cfif IsPDFObject(test)> 
    This is PDF
<cfelse> 
    This is not a PDF
</cfif>
```







# Categories

[Decision logic](../../categories/decision.md), [PDFs](../../categories/pdf.md)