# IsObject()

Determines whether a value is an object.

- True, if the value represents a CFML object.
- False if the value is any other type of data, such as an integer, string, date, or struct.

```
IsObject( value=any );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| value | any | Yes | A value, typically the name of a variable. |  |

# Examples

```cfml
writeDump(label:"String value", var:isObject("Susi"));
writeDump(label:"isObject() with array function", var:isObject(arrayNew(1)));
writeDump(label:"CreateObject in Java", var:isObject(createObject('java','java.util.HashMap')));
writeDump(label:"CreateObject in Java with init()", var:isObject(createObject('java',"java.lang.StringBuffer").init()));
```







# Categories

[Decision logic](../../categories/decision.md), [Objects](../../categories/object.md)