# IsNumericDate()

Evaluates whether a real number is a valid representation of a date (date/time object).

```
IsNumericDate( number=any );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| number | any | Yes | A real number *Alias: value* |  |

# Examples

```cfml
writeDump(label:"Single numeric value", var:isNumericDate(1));
writeDump(label:"Integer value", var:isNumericDate(1000000000));
writeDump(label:"Now()", var:isNumericDate(now()));
writeDump(label:"Date value", var:isNumericDate("01/01/04"));
writeDump(label:"Minus value", var:isNumericDate("-1111111111"));
writeDump(label:"String value", var:isNumericDate("efsdf"));
```







# Categories

[Decision logic](../../categories/decision.md), [Numbers](../../categories/number.md), [Date and time](../../categories/datetime.md)