# IsNumeric()

Determines if the object represents a numeric

```
IsNumeric( string=any );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| string | any | Yes | A string or a variable that contains a number. *Alias: value* |  |

# Examples

```cfml
writeDump(label:"Single numeric value", var:isNumeric(1));
writeDump(label:"Decimal value", var:isNumeric(1.3));
writeDump(label:"Numeric value with quotes", var:isNumeric("1"));
writeDump(label:"String value", var:isNumeric("susi"));
writeDump(label:"Boolean value", var:isNumeric(true));
writeDump(label:"Date value", var:isNumeric("6/2017"));
writeDump(label:"isNumeric() with another function", var:isNumeric(arrayNew(1)));
str = "Susi";
writeDump(label:"String length", var:isNumeric(str.length()));
writeDump(label:"Numbers with space", var:isNumeric(' 123 '));
```







# Categories

[Decision logic](../../categories/decision.md), [Numbers](../../categories/number.md)

# See Also

[LSIsNumeric()](lsisnumeric.md), [ToNumeric()](tonumeric.md)