# IsJson()

Evaluates whether a string is in valid JSON (JavaScript Object Notation) data interchange format.

```
IsJson( var=any, format=string );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| var | any | Yes | A string or variable that represents one. *Alias: value* |  |
| format | string | No | The format of the input string. Possible values are: - **json**: Standard JSON format - **json5**: JSON5 format which allows additional features such as comments and unquoted keys | json5 |

# Examples

```cfml
writeDump(label:"Array", var:isJson("[1,2,3]"));
writeDump(label:"Single number value", var:isJson(1));
writeDump(label:"String value", var:isJson('susi12345'));
writeDump(label:"String value with serializeJSON", var:isJson(serializeJSON('susi')));
writeDump(label:"Boolean value with serializeJSON", var:isJson(serializeJSON(true)));
writeDump(label:"CreateDateTime with serializeJSON", var:isJson(serializeJSON(CreateDateTime(2018,1,1,1,1,1))));
qry=queryNew('aaa,bbb', "varchar, varchar", [["a","b"],["c","d"]]);
writeDump(label:"Query", var: isJson(qry));
```







# Categories

[Decision logic](../../categories/decision.md), [JSON](../../categories/json.md), [JavaScript](../../categories/javascript.md)