# IsInstanceOf()

Determines whether an object is an instance of a Lucee interface or component, or of a Java class.

```
IsInstanceOf( obj=any, type=string );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| obj | any | Yes | The CFC instance or Java object that you are testing *Alias: value* |  |
| type | string | Yes | The name of the interface, component, or Java class of which the object might be an instance. |  |

# Examples

```cfml
writeDump(isInstanceOf({},"java.util.Map")); // true
writeDump(isInstanceOf("Lucee","java.util.Map")); // false
writeDump(isInstanceOf("Lucee","java.lang.String")); // true
```







# Categories

[Components (CFCs)](../../categories/component.md), [Decision logic](../../categories/decision.md), [Java](../../categories/java.md)

# See Also

[Data Types in Lucee](../../recipes/types-in-lucee.md)