# IsEmpty()

Returns whether or not a given value is "empty".

The following data types can be checked:

* Strings (a zero length string will return `true`)
* Arrays (an array with no elements will return `true`)
* Structs (a struct with no keys will return `true`)
* Query (a query with no rows will return `true`)

```
IsEmpty( value=any );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| value | any | Yes | The value to check. Can be either a string, array, struct or query object. *Alias: object* |  |

# Examples

The following statements all evaluate to true:

```cfml
writeOutput('Strings');
writeDump(IsEmpty( '' )); // true;
writeDump(IsEmpty( ' ' )); // false;
writeDump(IsEmpty( '0' )); // false;

writeOutput('arrays');
writeDump(IsEmpty( [] )); // true;
writeDump(IsEmpty( [ 1, 2, 3 ] )); // false;

writeOutput('structs');
writeDump(IsEmpty( {} )); // true;
writeDump(IsEmpty( { key="value" } )); // false;

writeOutput('queries');
writeDump(IsEmpty( QueryNew( 'column' ) )); // true;
writeDump(IsEmpty( QueryNew( 'column', 'varchar', [ [ 'value' ] ] ) )); // false;

writeOutput('numerics always non-empty');
writeDump(IsEmpty( 0 )); // false;
writeDump(IsEmpty( 1 )); // false;

writeOutput('booleans always non-empty');
writeDump(IsEmpty( false )); // false;
writeDump(IsEmpty( true )); // false;
```

>>>> Prior to Lucee 4.5.1.016, `IsEmpty( 0 )` and `IsEmpty( false )` both returned true.







# Categories

[Decision logic](../../categories/decision.md)

# See Also

[Empty()](empty.md)