# IsDefined()

Evaluates a string value to determine whether the variable named in it exists.

For better performance and security, it's recommended to use [StructKeyExists()](structkeyexists.md) instead

**Status:** deprecated

```
IsDefined( value=string );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| value | string | Yes | String, enclosed in quotation marks. Name of variable to test for. *Alias: variable* |  |

# Examples

```cfml
//using isDefined with condition statement
if(isDefined("form.reset")){
	//Code to be Executed
}
str={};
str.value="test";
writeDump(isDefined("str.value"));//true
```




## Related System Properties / Environment Variables

- [LUCEE_ISDEFINED_LIMIT](../environment-variables-system-properties.md#lucee_isdefined_limit) - Alias for lucee.security.limitEvaluation, limits variable evaluation in isDefined
  ***Type:** boolean*
- [LUCEE_SECURITY_ISDEFINED](../environment-variables-system-properties.md#lucee_security_isdefined) - Alias for lucee.security.limitEvaluation, limits variable evaluation in isDefined and related functions
  ***Type:** boolean*
- [LUCEE_SECURITY_LIMITEVALUATION](../environment-variables-system-properties.md#lucee_security_limitevaluation) - Disable evaluating expressions when accessing scopes, Lucee 7 defaults to enabling this setting for security reasons. A boolean value. If enabled, limits variable evaluation in functions/tags. If enabled, you cannot use expressions within [ ] like this: susi[getVariableName()]. This affects the following functions: IsDefined, structGet, structSort (when using pathToSubElement), empty and the following tags: savecontent attribute `variable`
  ***Type:** boolean, **Default:** false (Lucee 6), true (Lucee 7)*



# Categories

[Decision logic](../../categories/decision.md)

# See Also

[IsNull()](isnull.md), [StructKeyExists()](structkeyexists.md)