# IsCustomFunction()

Determines whether a name represents a custom function

```
IsCustomFunction( name=any, type=string );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| name | any | Yes | Name of a custom function. Must not be in quotation marks. If not a defined variable or function name, Lucee generates an error. |  |
| type | string | No | Limit to a specific type: - closure - lambda - udf If not specified, all custom function types are accepted. |  |

# Examples

```cfml
writeDump(isCustomFunction(realUDF));
writeDump(isCustomFunction(xxx));
testFun = realUDF;
X = 1;
writeDump(isCustomFunction(testFun));
writeDump(isCustomFunction(X))
function realUDF() {
	return 1;
}
function xxx(void) {}
```







# Categories

[Components (CFCs)](../../categories/component.md), [Decision logic](../../categories/decision.md)

# See Also

[IsClosure()](isclosure.md)