# IsClosure()

Checks if given Object is a closure or not.

```
IsClosure( object=any );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| object | any | Yes | The object that is checked. *Alias: obj, value* |  |

# Examples

```cfml
// closure
c = function(){
  return true;
};

// user defined function (UDF)
function u() {
    return true;
}

dump(var=isClosure(c), label="closure");
dump(var=isClosure(u), label="user defined function");
```







# Categories

[Components (CFCs)](../../categories/component.md), [Decision logic](../../categories/decision.md)

# See Also

[IsCustomFunction()](iscustomfunction.md), [<cffunction>](../tags/function.md)