# IsBoolean()

Determines if the object represents a boolean value

```
IsBoolean( value=any );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| value | any | Yes | Number or string |  |

# Examples

### The following statements evaluate to `true`:

```cfml
    writeDump(IsBoolean( true ));
    writeDump(IsBoolean( false ));
    writeDump(IsBoolean( 0 ));
    writeDump(IsBoolean( -10.4 ));
    writeDump(IsBoolean( 3.6 ));
    writeDump(IsBoolean( "yes" ));
    writeDump(IsBoolean( "no" ));
    writeDump(IsBoolean( "true" ));
    writeDump(IsBoolean( "false" ));
    writeDump(IsBoolean( "0" ));
    writeDump(IsBoolean( "-10.4" ));
    writeDump(IsBoolean( "3.6" ));
```

### The following statements evaluate to `false`:

```cfml
    writeDump(IsBoolean( Now() ));
    writeDump(IsBoolean( {} ));
    writeDump(IsBoolean( [] ));
    writeDump(IsBoolean( QueryNew('') ));
    writeDump(IsBoolean( "" ));
    writeDump(IsBoolean( "a string" ));

```







# Categories

[Decision logic](../../categories/decision.md), [Booleans](../../categories/boolean.md)