# IsArray()

Determines whether a value is an array.

True, if value is an array, a query column object, or XML.

also number = Dimension; function tests whether the array has exactly this dimension

```
IsArray( value=any, dimension=number );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| value | any | Yes | Variable or array name |  |
| dimension | number | No | function tests whether the array has exactly this dimension. | -999 |

# Examples

```cfml
writeDump(label:"Empty Array", var:isArray([]));
writeDump(label:"ArrayNew", var:isArray(arrayNew(1)));
writeDump(label:"ArrayNew position3", var:isArray(arrayNew(3), 3));
writeDump(label:"Boolean value", var:isArray(true));
writeDump(label:"String value", var:isArray("array"));
```







# Categories

[Arrays](../../categories/array.md), [Decision logic](../../categories/decision.md)