# Invoke()

invokes a function/operation of the given object and if given object is a string, Lucee tries to load as component.

```
Invoke( object=any, name=string, arguments=any );
```

**Returns:** object

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| object | any | Yes | a component, struct or scope that holds a function, can also be the name of a component, in this case the component get loaded. *Alias: cfcInstance, obj, value, variable* |  |
| name | string | Yes | name of the function/operation *Alias: methodName, method, functionName, function* |  |
| arguments | any | No | arguments to pass to the function/operation *Alias: params, args, argumentCollection* |  |

# Examples

```cfml
<cfscript>
    writeDump(label:"structure with invoke()", var:invoke(variables,'myStruct',{a:'First'}));
    private function myStruct(){
    	return "myStruct:"&serializeJson(arguments);
    }
    
    writeDump(label:"Adding numbers with invoke()", var:invoke(variables,'calc',{a:3,b:2}));
    private function calc(numeric a, numeric b){
    	return a+b;
    }
</cfscript>

```







# See Also

[<cfinvoke>](../tags/invoke.md)