# internalRequest()

Makes a request to the CFML Engine internally. also available in 5.x as _internalRequest()

Great for CI / tests, internalRequest allows you to call another cfml page on the same server without needing to make an http call

**Introduced:** 6.0.0.161

```
internalRequest( template=string, method=string, urls=any, forms=any, cookies=struct, headers=struct, body=any, charset=string, addToken=boolean, throwonerror=boolean );
```

**Returns:** struct

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| template | string | Yes | Template path (script name) for the request (example:/test/index.cfm). |  |
| method | string | No | method of the request (GET,POST,PUT,DELETE ...) | get |
| urls | any | No | URL scope passed to the request (query string). This can be a struct or a string following this format [name1=value1&name2=value2]. *Alias: url* |  |
| forms | any | No | FORM scope passed to the request.This can be a struct or a string following this format [name1=value1&name2=value2]. *Alias: form* |  |
| cookies | struct | No | Cookie scope passed to the request *Alias: cookie* |  |
| headers | struct | No | Request header entries passed to the request *Alias: header* |  |
| body | any | No | body to send with the request |  |
| charset | string | No | charset used for the request, if not set the web charset is used. |  |
| addToken | boolean | No | if yes add urlToken as cookie | false |
| throwonerror | boolean | No | if true (default) and the called page throws an exception, that exception is also thrown within the caller request. If false it is caught and only reported in the resulting struct. | true |

# Examples

*There are currently no examples for this function*







# Categories

[Internet Protocols](../../categories/protocols.md), [Lucee Server related Tags, Functions and Guides](../../categories/server.md)

# See Also

[<cfhttp>](../tags/http.md)