# InspectTemplates()

Flag all the cfml code (cfm, cfcs) in the cache of compiled code (aka the Page Pool) to be checked once for any changes.

This can used for example, when Inspect Templates is set to Never (Server/Web Administrator: Settings -> Performance/Caching)

This is way more efficient than [PagePoolClear()](pagepoolclear.md) which simply clears the entire cache, which is expensive.

Since 5.3.6

**Introduced:** 5.3.6.2

```
InspectTemplates( );
```

**Returns:** boolean

*This function does not take any arguments.*

# Usage Notes

This only clears the cache for the **current** Application, plus all Server and Web Context mappings. 

Other per Application mappings are not affected

# Examples

```cfml
	v = ListToArray(server.lucee.version,".");
	if ((v[1] >= 6) ||
			(v[1] >= 5 && v[2] >= 3 && v[3] >= 6) ||
			(v[1] == 5 && v[2] >= 4)){
		InspectTemplates();
	} else {
		echo (server.lucee.version);
		echo (" doesn't support InspectTemplates(), only 5.3.6+");
	}
```







# Categories

[Cache](../../categories/cache.md), [Lucee Server related Tags, Functions and Guides](../../categories/server.md)

# See Also

[PagePoolClear()](pagepoolclear.md), [PagePoolList()](pagepoollist.md), [SystemCacheClear()](systemcacheclear.md), [Template Performance / Caching](../../guides/deploying-lucee-server-apps/webserver-cache.md)