# InputBaseN()

Converts string, using the base specified by radix, to an integer.

For example: `#InputBaseN("3ff",16)#`

```
InputBaseN( string=string, radix=number );
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| string | string | Yes | String that represents a number, in the base specified by radix. |  |
| radix | number | Yes | Base of the number represented by string, in the range 2-36. |  |

# Examples

```cfml
	writeDump(InputBaseN("100100",2))//36 Binary to decimal format
	writeDump(InputBaseN("545",8))//357 Decimal to Octal format
	writeDump(InputBaseN("A",16))//10 Hexadecimal to decimal
```







# Categories

[Math](../../categories/math.md), [Numbers](../../categories/number.md)

# See Also

[FormatBaseN()](formatbasen.md)