# ImageXORDrawingMode()

Sets the paint mode of the image to alternate between the image's current color and the new specified color.

**Requires Extension:** [Image Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#B737ABC4-D43F-4D91-8E8E973E37C40D1B)

```
ImageXORDrawingMode( image=any, color=string );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| image | any | Yes | The image on which this operation is performed. *Alias: name* |  |
| color | string | Yes | the color (The default value is "black"): - Hexadecimal value of RGB color. For example, specify the color white as ##FFFFFF or FFFFFF. - String value of color (for example, "black", "red", "green"). - List of three numbers for (R,G,B) values. Each value must be in the range 0-255. *Alias: colour* |  |

# Examples

### Function Example

```cfml
imgObj = imageNew("",152,152,"rgb","149c82");
imageXORDrawingMode(imgObj,"dddddd");
imagesetDrawingColor(imgObj,"white");
imagedrawRect(imgObj,50,50,50,50,"yes");
for (i=1;i LTE 100;i=i+1) {
    x = randRange(0,152);
    y = randRange(0,152);
    imagedrawPoint(imgObj,x,y);
}
cfimage(action="writeToBrowser", source=imgObj);
```







# Categories

[Image manipulation](../../categories/image.md)

# See Also

[image.XORDrawingMode()](../objects/image/xordrawingmode.md)