# ImageWriteBase64()

Writes Base64 images to the specified filename and destination.

**Requires Extension:** [Image Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#B737ABC4-D43F-4D91-8E8E973E37C40D1B)

```
ImageWriteBase64( image=any, destination=string, format=string, inHTMLFormat=boolean );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| image | any | Yes | The image on which this operation is performed. *Alias: name* |  |
| destination | string | Yes | The path for the destination file. |  |
| format | string | Yes | the image format |  |
| inHTMLFormat | boolean | No | Specify whether Base64 output includes the headers used by the Base64 images in the HTML "img" tag ("data:image/{format};base64,...") : - true - false (default) |  |

# Examples

```cfml
	imgObj = imageNew("",200,200,"rgb","red");
	imgObj.writeBase64('base64.txt','jpg','true');
```







# Categories

[Image manipulation](../../categories/image.md)

# See Also

[ImageReadBase64()](imagereadbase64.md), [ToBase64()](tobase64.md), [image.writeBase64()](../objects/image/writebase64.md)