# ImageWrite()

Writes an image to the specified filename or destination.

**Requires Extension:** [Image Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#B737ABC4-D43F-4D91-8E8E973E37C40D1B)

```
ImageWrite( image=any, destination=string, quality=number, overwrite=boolean, noMetaData=boolean );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| image | any | Yes | The image on which this operation is performed. *Alias: name* |  |
| destination | string | No | The path to write the file. If you create the image with the ImageNew function or another operation where you do not specify the filename, specify the destination parameter. The file format is derived from the extension of the filename. The default value for this parameter is the filename of the original image source. |  |
| quality | number | No | Defines the JPEG quality used to encode the image. This parameter applies only to destination files with an extension of JPG or JPEG. Valid values are fractions that range from 0 through 1 (the lower the number, the lower the quality). The default value is 0.75. | 0.75 |
| overwrite | boolean | No | If set to true (default), overwrites the destination file. | true |
| noMetaData | boolean | No | if true the meta data from the source file are ignored. | false |

# Examples

```cfml
	newImg = imageNew("",200,200,"rgb","red");
	newImg.write("picture.png");
```







# Categories

[File handling](../../categories/files.md), [Image manipulation](../../categories/image.md)

# See Also

[image.write()](../objects/image/write.md)