# ImageTranslateDrawingAxis()

Translates the origin of the image context to the point (x,y) in the current coordinate system.

Modifies the image context so that its new origin corresponds to the point (x,y) in the image's original coordinate system.

**Requires Extension:** [Image Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#B737ABC4-D43F-4D91-8E8E973E37C40D1B)

```
ImageTranslateDrawingAxis( image=any, x=number, y=number );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| image | any | Yes | The image on which this operation is performed. *Alias: name* |  |
| x | number | Yes | x coordinate |  |
| y | number | Yes | y coordinate |  |

# Examples

### Function Example

```cfml
	imgObj = imageNew("",200,200,"rgb","149c82");
	imagetranslateDrawingAxis(imgObj,40,40);
	imgObj.drawRect(50,50,70,50,"yes");
	cfimage(action="writeToBrowser", source=imgObj);
```







# Categories

[Image manipulation](../../categories/image.md)

# See Also

[image.translateDrawingAxis()](../objects/image/translatedrawingaxis.md)