# ImageTranslate()

Copies an image to a new location on the plane.

**Requires Extension:** [Image Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#B737ABC4-D43F-4D91-8E8E973E37C40D1B)

```
ImageTranslate( image=any, xTrans=number, yTrans=number, interpolation=string );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| image | any | Yes | The image on which this operation is performed. *Alias: name* |  |
| xTrans | number | Yes | Displacement in the x direction. |  |
| yTrans | number | Yes | Displacement in the y direction. |  |
| interpolation | string | No | Type of interpolation: - nearest (default): Applies the nearest neighbor method of interpolation. Image quality is lower than the other interpolation methods, but processing is fastest. - bilinear: Applies the bilinear method of interpolation. The quality of the image is less pixelated than the default, but processing is slower. - bicubic: Applies the bicubic method of interpolation. Generally, the quality of image is highest with this method and processing is slowest. | nearest |

# Examples

```cfml
  imgObj = imageNew("",152,152,"rgb","149c82");
  imgObj.translate(10,10);
  imgObj.drawRect(40,50,70,50,"yes");
  cfimage(action="writeToBrowser", source=imgObj);
```







# Categories

[Image manipulation](../../categories/image.md)

# See Also

[image.translate()](../objects/image/translate.md)