# ImageShearDrawingAxis()

Shears the drawing canvas.

**Requires Extension:** [Image Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#B737ABC4-D43F-4D91-8E8E973E37C40D1B)

```
ImageShearDrawingAxis( image=any, shx=number, shy=number );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| image | any | Yes | The image on which this operation is performed. *Alias: name* |  |
| shx | number | Yes | The multiplier by which coordinates are shifted in the positive x axis direction as a function of the y coordinate. |  |
| shy | number | Yes | the multiplier by which coordinates are shifted in the positive y axis direction as a function of the x coordinate. |  |

# Examples

```cfml
  imgObj = imageNew("",152,152,"rgb","149c82");
  imgObj.shearDrawingAxis(0.5,0.5);
  imgObj.drawRect(40,50,70,50,"yes");
  cfimage(action="writeToBrowser", source=imgObj);
```







# Categories

[Image manipulation](../../categories/image.md)

# See Also

[image.shearDrawingAxis()](../objects/image/sheardrawingaxis.md)