# ImageShear()

Shears an image either horizontally or vertically.

**Requires Extension:** [Image Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#B737ABC4-D43F-4D91-8E8E973E37C40D1B)

```
ImageShear( image=any, shear=number, direction=string, interpolation=string );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| image | any | Yes | The image on which this operation is performed. *Alias: name* |  |
| shear | number | Yes | Shear value. Coordinates can be integers or real numbers. |  |
| direction | string | No | Shear direction: - horizontal (default) - vertical | horizontal |
| interpolation | string | No | Type of interpolation: - nearest (default): Applies the nearest neighbor method of interpolation. Image quality is lower than the other interpolation methods, but processing is fastest. - bilinear: Applies the bilinear method of interpolation. The quality of the image is less pixelated than the default, but processing is slower. - bicubic: Applies the bicubic method of interpolation. Generally, the quality of image is highest with this method and processing is slowest. | nearest |

# Examples

```cfml
myImg = imageNew("",100,50,"rgb","B33771");
imageShear(myImg,4,"vertical");
cfimage(action="writeToBrowser", source=myImg);
```







# Categories

[Image manipulation](../../categories/image.md)

# See Also

[image.shear()](../objects/image/shear.md)