# ImageSharpen()

Sharpens an image by using the unsharp mask filter.

**Requires Extension:** [Image Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#B737ABC4-D43F-4D91-8E8E973E37C40D1B)

```
ImageSharpen( image=any, gain=number );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| image | any | Yes | The image on which this operation is performed. *Alias: name* |  |
| gain | number | No | Gain values can be integers or real numbers. The default value is 1.0. The value determines whether the image is blurred or sharpened: - if > 0, the image is sharpened - if = 0, no effect - if < 0, the image is blurred | 1 |

# Examples

```cfml
img=imageRead("https://avatars1.githubusercontent.com/u/10973141?s=280&v=4");
imageSharpen(img,2);
cfimage(action="writeToBrowser",source=img);
```







# Categories

[Image manipulation](../../categories/image.md)

# See Also

[image.sharpen()](../objects/image/sharpen.md)