# ImageSetDrawingTransparency()

Specifies the degree of transparency of drawing functions.

**Requires Extension:** [Image Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#B737ABC4-D43F-4D91-8E8E973E37C40D1B)

```
ImageSetDrawingTransparency( image=any, percent=number );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| image | any | Yes | The image on which this operation is performed. *Alias: name* |  |
| percent | number | No | Percent of transparency, a floating point number in range 0-100 | 1 |

# Examples

```cfml
  TextCharacteristics = { size="20", style="bold", strikethrough="false", underline="false"};
  imgObj = imageNew("",152,152,"rgb","149c82");
  imgObj.setDrawingTransparency(50);
  imgObj.drawText("Lucee",20,50,TextCharacteristics);
  cfimage(action="writeToBrowser", source=imgObj);
```







# Categories

[Image manipulation](../../categories/image.md)

# See Also

[image.setDrawingTransparency()](../objects/image/setdrawingtransparency.md)