# ImageSetDrawingColor()

Sets the current drawing color for images. All subsequent graphics operations use the specified color.

**Requires Extension:** [Image Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#B737ABC4-D43F-4D91-8E8E973E37C40D1B)

```
ImageSetDrawingColor( image=any, color=string );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| image | any | Yes | The image on which this operation is performed. *Alias: name* |  |
| color | string | Yes | Drawing color (The default value is "black"): - Hexadecimal value of RGB color. For example, specify the color white as ##FFFFFF or FFFFFF. - String value of color (for example, "black", "red", "green"). - List of three numbers for (R,G,B) values. Each value must be in the range 0-255. *Alias: colour* |  |

# Examples

```cfml
myImg = imageNew("",300,200,"rgb","eccc68");
imageSetDrawingColor(myImg,"009432");//All subsequent graphics operations use the specified color.
ImageDrawLine(myImg,0,0,300,200)
ImageDrawText(myImg,"Plant green,",10,90)
ImageDrawText(myImg,"Save world!",180,100)
cfimage(action="writeToBrowser", source=myImg);
```







# Categories

[Image manipulation](../../categories/image.md)

# See Also

[image.setDrawingColor()](../objects/image/setdrawingcolor.md)