# ImageSetDrawingAlpha()

Sets the current drawing alpha for images. All subsequent graphics operations use the specified alpha.

**Requires Extension:** [Image Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#B737ABC4-D43F-4D91-8E8E973E37C40D1B)

```
ImageSetDrawingAlpha( image=any, alpha=number );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| image | any | Yes | The image on which this operation is performed. *Alias: name* |  |
| alpha | number | Yes | a floating point number in range 0-1 |  |

# Examples

```cfml
	img=imageNew("", 250, 250, "RGB", "a29bfe");

	imagesetDrawingAlpha(img ,0.3);
	imagedrawRect(img, 50,  50, 50, 50);

	imagesetDrawingAlpha(img ,0.6);
	imagedrawRect(img, 75, 75, 75, 75);

	imagesetDrawingAlpha(img ,1);
	imagedrawRect(img, 100, 100, 100, 100);

	writeOutput(img);
```







# Categories

[Image manipulation](../../categories/image.md)

# See Also

[image.setDrawingAlpha()](../objects/image/setdrawingalpha.md)